unit IWHTMLControls32;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  IWNetClasses, IWNETBaseControl,
  {$ELSE}
  Classes,
    {$IFDEF Linux}
    IWCLXComponent, IWCLXClasses,
    {$ELSE}
    IWVCLComponent, IWVCLClasses,
    {$ENDIF}
  {$ENDIF}
  IWBaseControl, IWControl32, IWHTMLTag, IWRenderContext,
  IWBaseInterfaces;

type
  TIWHRule23Align = (haLeft, haRight, haCenter);

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWHRule32.bmp}
  TIWHRule32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWHRule32), 'TIWHRule32.bmp')]
  {$ENDIF}
  TIWHRule32 = class(TIWCustomControl32)
  protected
    FPercents : boolean;
    FAlign : TIWHRule23Align;
    FNoShade : boolean;
    procedure InitControl; override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property Align : TIWHRule23Align read FAlign write FAlign;
    property Percents : boolean read FPercents write FPercents default FALSE;
    property NoShade : boolean read FNoShade write FNoShade default TRUE;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWList32.bmp}
  TIWList32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWList32), 'TIWList32.bmp')]
  {$ENDIF}
  TIWList32 = class(TIWCustomControl32)
  protected
    FNumbered: Boolean;
    FItems: TIWStringList;
    procedure OnItemsChange(ASender : TObject);
    procedure SetItems(AValue: TIWStringList);
    procedure SetNumbered(const AValue: Boolean);
    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    procedure Clear; virtual;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property Items: TIWStringList read FItems write SetItems;
    property Numbered: boolean read FNumbered write SetNumbered;
  end;

  TIWLinkBase32 = class(TIWCustomControl32)
  protected
    FRawText: Boolean;
    procedure InitControl; override;

    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
  public
    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
  published
    property Enabled;
//    property ExtraTagParams;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property RawText: Boolean read FRawText write FRawText;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWHyperLink32.bmp}
  TIWHyperLink32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWHyperLink32), 'TIWHyperLink32.bmp')]
  {$ENDIF}
  TIWHyperLink32 = class(TIWLinkBase32, IIWSubmitControl)
  protected
    FSubmitParam : String;
    procedure Submit(const AValue: string); override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function GetSubmitParam : String;
  published
    property OnClick;
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
  end;

  TIWCustomURL32 = class(TIWLinkBase32)
  protected
    FTerminateApp: boolean;
    FURL: string;
    //
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property URL: string read FURL write FURL;
  protected
    procedure InitControl; override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property TerminateApp: boolean read FTerminateApp write FTerminateApp;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWURL32.bmp}
  TIWURL32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWURL32), 'TIWURL32.bmp')]
  {$ENDIF}
  TIWURL32 = class(TIWCustomURL32)
  published
    property URL;
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
  end;

implementation

uses
  SysUtils,
  {$IFNDEF VSNET}
  {$IFDEF Linux}QForms, {$ELSE}Forms,{$ENDIF}
  {$ENDIF}
  IWUtils, IWCompLabel32, IWBaseForm, IWGlobal, IWServerControllerBase;

{$IFDEF VSNET}
function TIWLinkBase32.getText: string;
begin
  Result := Caption;
end;

procedure TIWLinkBase32.setText(AValue: string);
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

{ TIWHRule32 }

procedure TIWHRule32.InitControl;
begin
  inherited;
  Width := 100;
  Height := 3;
  FPercents := FALSE;
  FAlign := haCenter;
  FNoShade := TRUE;
end;

function TIWHRule32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Result := TIWHTMLTag.CreateTag('HR');
  try
    if FPercents then
    begin
      Result.AddStringParam('WIDTH', IntToStr(Width) + '%');
    end
    else
    begin
      Result.AddIntegerParam('WIDTH', Width);
    end;
    Result.AddIntegerParam('SIZE', Height);
    case FAlign of
      haLeft  : begin
                  Result.AddStringParam('ALIGN', 'LEFT');
                end;
      haRight : begin
                  Result.AddStringParam('ALIGN', 'RIGHT');
                end;
      haCenter: begin
                  Result.AddStringParam('ALIGN', 'CENTER');
                end;
    end;
    if FNoShade then
    begin
      Result.Add('NOSHADE');
    end;
  except
    FreeAndNil(Result);
    raise;
  end;
end;

{ TIWList32 }

procedure TIWList32.InitControl;
begin
  inherited;
  FItems := TIWStringList.Create;
  FItems.OnChange := OnItemsChange;
  Height := 24;
  Width := 116;
end;

procedure TIWList32.Dispose(ADispose: Boolean); 
begin
  FreeAndNil(FItems);
  inherited;
end;

function TIWList32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  i: Integer;
  s: string;
begin
  Result := NIL;
  if Items.Count > 0 then
  begin
     Result := TIWHTMLTag.CreateTag('table');
     try
        for i := 0 to Items.Count - 1 do
        begin
           with Result.Contents.AddTag('TR') do
           begin
              s := '';
              with Contents.AddTag('TD') do
              begin
                 if Numbered then
                 begin
                    s := s + IntToStr(i + 1) + '.';
                 end
                 else
                 begin
                    s := s + Chr(149);
                 end;
                 Contents.AddTagAsObject(WebFont.FontToStringTag32(s));
              end;
              with Contents.AddTag('TD') do
              begin
                 Contents.AddTagAsObject(WebFont.FontToStringTag32(Items.Strings[i]));
              end;
           end;
        end;
        if Result.Contents.Count = 0 then
           Result.Contents.AddText('');
     except
        FreeAndNil(Result);
        raise;
     end;
  end;
end;

procedure TIWList32.SetItems(AValue: TIWStringList);
begin
  FItems.Assign(AValue);
  Invalidate;
end;

procedure TIWList32.SetNumbered(const AValue: Boolean);
begin
  if FNumbered <> AValue then begin
    FNumbered := AValue;
    Invalidate;
  end;
end;

procedure TIWList32.Clear;
begin
  Items.Clear;
end;

procedure TIWList32.OnItemsChange(ASender: TObject);
begin
  Invalidate;
end;

{ TIWLinkBase32 }

procedure TIWLinkBase32.InitControl;
begin
  inherited;
  Width := 65;
  Height := 17;
end;


{ TIWHyperLink32 }


function TIWHyperLink32.GetSubmitParam: String;
begin
  Result := FSubmitParam;
end;

function TIWHyperLink32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LLabel: TIWLabel32;
  LAction: string;
  LForm: TIWBaseForm;
begin
  if Enabled then begin
    Result := TIWHTMLTag.CreateTag('A'); try
      LForm := TIWBaseForm(AContext.WebApplication.ActiveForm);
      LAction := LForm.FormAction;
      if GServerController.SessionTrackingMethod in [tmHidden, tmCookie] then begin
        Result.AddStringParam('HREF', IncludeURLPathDelimiter(LAction) + 'call?' + HTMLName
          + '&IW_FormName=' + LForm.Name
          + '&IW_FormClass=' + LForm.ClassName            
          + '/' + IntToStr(AContext.WebApplication.TrackId) + '/' + AContext.WebApplication.AppID);
      end else begin
        Result.AddStringParam('HREF', LAction + '/call?' + HTMLName + '&IW_FormName=' + LForm.Name
          + '&IW_FormClass=' + LForm.ClassName);
      end;
      if not FRawText then begin
        Result.Contents.AddTagAsObject(WebFont.FontToStringTag32(TextToHtml(Caption)));
      end else begin
        Result.Contents.AddTagAsObject(WebFont.FontToStringTag32(Caption));
      end;
    except FreeAndNil(Result); raise; end;
  end else begin
    LLabel := TIWLabel32.Create{$IFNDEF VSNET}(Self){$ENDIF}; try
      LLabel.Name := HTMLName;
      LLabel.RawText := FRawText;
      LLabel.Width := Width;
      LLabel.Height := Height;
      LLabel.Visible := true;
      Result := LLabel.RenderHTML(AContext);
    finally FreeAndNil(LLabel); end;
  end;
end;

procedure TIWHyperLink32.Submit(const AValue: string);
begin
  FSubmitParam := AValue;
  DoClick;
end;

{ TIWCustomURL32 }

procedure TIWCustomURL32.InitControl;
begin
  inherited;
  FURL := '';
end;

function TIWCustomURL32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LURL: string;
begin
  if not Enabled then begin
    Result := TIWHTMLTag.CreateTag('DIV'); try
      if not FRawText then begin
        Result.Contents.AddText(TextToHTML(Caption));
      end else begin
        Result.Contents.AddText(Caption);
      end;
    except FreeAndNil(Result); raise; end;
  end else begin
    Result := TIWHTMLTag.CreateTag('A');
    try
      if TerminateApp then begin
        LURL := FURL;
        if AnsiSameText(Copy(LURL, 1, 7), 'http://') then begin
          Delete(LURL, 1, 7);
        end else if AnsiSameText(Copy(LURL, 1, 8), 'https://') then begin
          Delete(LURL, 1, 8);
          LURL := '_s_.' + LURL;
        end;
        Result.AddStringParam('HREF', '/STOP/' + AContext.WebApplication.AppID + '/' + LURL);
      end else begin
        Result.AddStringParam('HREF', FURL);
      end;
      if not FRawText then begin
        Result.Contents.AddTagAsObject(WebFont.FontToStringTag32(TextToHTML(Caption)));
      end else begin
        Result.Contents.AddTagAsObject(WebFont.FontToStringTag32(Caption));
      end;
    except
      FreeAndNil(Result);
      raise;
    end;
  end;
end;

end.
